<?php

declare(strict_types=1);

namespace Avodel\Clock\Behat;

use Avodel\Clock\ClockInterface;
use DateTimeImmutable;

class ClockStub implements ClockInterface
{
    private ?DateTimeImmutable $currentTime = null;

    public function setCurrentTime(DateTimeImmutable $date): void
    {
        $this->currentTime = $date;
    }

    public function getCurrentTime(): DateTimeImmutable
    {
        if ($this->currentTime) {
            return $this->currentTime;
        }

        return new DateTimeImmutable();
    }
}
