<?php

declare(strict_types=1);

namespace Avodel\Clock\Behat;

use Avodel\Clock\ClockInterface;
use Psr\Clock\ClockInterface as PsrClockInterface;
use DateTimeImmutable;

class ClockStub implements ClockInterface, PsrClockInterface
{
    private ?DateTimeImmutable $currentTime = null;

    public function setCurrentTime(DateTimeImmutable $date): void
    {
        $this->currentTime = $date;
    }

    public function getCurrentTime(): DateTimeImmutable
    {
        trigger_deprecation('avodel/clock', '1.0.0', 'The "%s" class is deprecated. Use "%s" instead.', ClockInterface::class, PsrClockInterface::class);

        return $this->now();
    }

    public function now(): DateTimeImmutable
    {
        if ($this->currentTime) {
            return $this->currentTime;
        }

        return new DateTimeImmutable();
    }
}
