<?php

declare(strict_types=1);

namespace Avodel\Clock;

use DateTimeImmutable;
use Psr\Clock\ClockInterface as PsrClockInterface;

final class Clock implements ClockInterface, PsrClockInterface
{
    /**
     * @deprecated
     */
    public function getCurrentTime(): DateTimeImmutable
    {
        trigger_deprecation('avodel/clock', '1.0.0', 'The "%s" class is deprecated. Use "%s" instead.', ClockInterface::class, PsrClockInterface::class);

        return $this->now();
    }

    public function now(): DateTimeImmutable
    {
        return new DateTimeImmutable();
    }
}
