<?php

namespace Avodel\Clock\DependencyInjection;

use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

final class AvodelClockExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        /** @var ConfigurationInterface $configuration */
        $configuration = $this->getConfiguration([], $container);

        /** @var array<string,string|array> $config */
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/Config/'));
        $loader->load('services.yaml');

        if ($config['behat']) {
            $loader->load('behat_services.yaml');
        }
    }
}
