# Clock

A PHP library providing a PSR-20 compliant clock implementation with Symfony ExpressionLanguage integration. The library enables time-based conditional logic in expressions and offers testing utilities for deterministic time manipulation in BDD scenarios.

## Business Logic

### Core Concept

**Problem:** Applications need consistent time handling across services, with the ability to:
1. Use time-based conditions in Symfony ExpressionLanguage
2. Mock time in tests for deterministic behavior

**Solution:** A lightweight clock abstraction that:
- Implements PSR-20 `ClockInterface` for standardized time access
- Exposes a `clock()` function in ExpressionLanguage for declarative time conditions
- Provides a stub implementation for testing

### Main Process

```
1. PRODUCTION USAGE
   │
   ├── Clock::now() → Returns current DateTimeImmutable
   │
   └── ExpressionLanguage evaluation
       │
       └── clock() function call
           │
           └── Date object with time-based methods
               │
               ├── isAfter(modifier)    → bool
               ├── isBefore(modifier)   → bool
               ├── isCurrentWeekDay(name) → bool
               └── date(modifier)       → formatted string

2. TESTING USAGE
   │
   ├── ClockStub::setCurrentTime(date) → Sets fixed time
   │
   └── ClockStub::now() → Returns fixed or current time
       │
       └── Behat step: Given Current time is "2024-01-15"
```

### Expression Language Functions

The `clock()` function returns a `Date` object with the following methods:

| Method | Arguments | Returns | Example |
|--------|-----------|---------|---------|
| `isAfter` | date modifier string | `bool` | `clock().isAfter('first day of this month')` |
| `isBefore` | date modifier string | `bool` | `clock().isBefore('+7 days')` |
| `isCurrentWeekDay` | weekday name | `bool` | `clock().isCurrentWeekDay('monday')` |
| `date` | modifier string | `Y-m-d H:i:s` | `clock().date('-1 month')` |

**Date Modifiers:** Uses PHP's `DateTimeImmutable::modify()` syntax (e.g., `+1 day`, `first day of this month`, `last monday`).

```gherkin
# In feature files
Given Current time is "2024-01-15 10:30:00"
```

## Dependencies

| Package | Purpose |
|---------|---------|
| `psr/clock` | PSR-20 ClockInterface |
| `symfony/expression-language` | ExpressionLanguage integration |

## Installation

```bash
composer require avodel/clock
```

## Configuration

No environment variables required. The library is configuration-free.

