<?php

declare(strict_types=1);

namespace Avodel\Clock\Behat;

use Behat\Behat\Context\Context;
use DateTimeImmutable;

class ClockContext implements Context
{
    public function __construct(
        private readonly ClockStub $clock,
    ) {
    }

    /**
     * @Given /^Current time is "([^"]*)"$/
     */
    public function currentTimeIs(string $date): void
    {
        $this->clock->setCurrentTime(new DateTimeImmutable($date));
    }
}
