<?php

declare(strict_types=1);

namespace Avodel\Clock\Behat;

use Psr\Clock\ClockInterface as PsrClockInterface;
use DateTimeImmutable;

class ClockStub implements PsrClockInterface
{
    private ?DateTimeImmutable $currentTime = null;

    public function setCurrentTime(DateTimeImmutable $date): void
    {
        $this->currentTime = $date;
    }

    public function now(): DateTimeImmutable
    {
        if ($this->currentTime) {
            return $this->currentTime;
        }

        return new DateTimeImmutable();
    }
}
