<?php

declare(strict_types=1);

namespace Avodel\Clock\FunctionProvider;

use Psr\Clock\ClockInterface;
use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

final class ClockExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{
    public function __construct(
        private readonly ClockInterface $clock
    ) {
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction(
                'clock',
                static function (): void {
                    // Not used, but required by the ExpressionFunction constructor
                },
                function () {
                    return new Date($this->clock->now());
                }
            ),
        ];
    }
}
