<?php

namespace Avodel\Clock\FunctionProvider;

use DateTimeImmutable;

final class Date
{
    public function __construct(private readonly DateTimeImmutable $currentTime)
    {
    }

    public function isAfter(string $date): bool
    {
        return $this->currentTime > $this->currentTime->modify($date);
    }

    public function isBefore(string $date): bool
    {
        return $this->currentTime < $this->currentTime->modify($date);
    }

    public function isCurrentWeekDay(string $name): bool
    {
        return strtolower($this->currentTime->format('l')) === strtolower($name);
    }

    public function date(string $modifier): string
    {
        return $this->currentTime->modify($modifier)->format('Y-m-d H:i:s');
    }
}