# Framework Bundle

## Purpose
Aggregates and configures the components of avodel/* in a Symfony application.

### Usage
```yaml
avodel_framework:
  lock_db_migration: true # If true, enables the avodel/migration-lock component.
  healthcheck: true # If true, enables the controller from avodel/healthcheck.

  clock: # If the key is present, enables the avodel/clock component.
    behat: true

  uuid: # If the key is present, enables the avodel/uuid component.
    behat: true

  logger: # If the key is present, enables the avodel/logger component.
    project_dir: '%kernel.project_dir%'
    elasticsearch:
      enabled: '%env(bool:ELASTICSEARCH_ENABLED)%'
      username: '%env(ELASTICSEARCH_USERNAME)%'
      password: '%env(ELASTICSEARCH_PASSWORD)%'
      url: '%env(ELASTICSEARCH_URL)%'
      index: '%env(ELASTICSEARCH_INDEX)%'
    exclusions:
      - {channel: "request", message: "Matched route \"{route}\"."}
      - {channel: "security", message: "Checking for authenticator support."}
      - {channel: "security", message: "Checking support on authenticator."}
      - {channel: "security", message: "Authenticator successful!"}
      - {channel: "security", message: "Authenticator set no success response: request continues."}
      - {channel: "security", message: "The \"{authenticator}\" authenticator set the response. Any later authenticator will not be called"}

  jwt_http_client: # If the key is present, enables the avodel/jwt-http-client component.
    clients:
      mail_service.client:
        http_client: mail_service.client
        jwt_storage: jwt_mail_service_cache
        auth:
          username: '%env(MAIL_SERVICE_API_USERNAME)%'
          password: '%env(MAIL_SERVICE_API_PASSWORD)%'

```