<?php

declare(strict_types=1);

namespace Avodel\FrameworkBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_framework');

        // @phpstan-ignore-next-line
        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('application_name')->isRequired()->end()
                ->booleanNode('lock_db_migration')->defaultFalse()->end()
                ->booleanNode('healthcheck')->defaultFalse()->end()
                ->arrayNode('clock')
                    ->children()
                        ->booleanNode('behat')->defaultFalse()->end()
                    ->end()
                ->end()
                ->arrayNode('uuid')
                    ->children()
                        ->booleanNode('behat')->defaultFalse()->end()
                    ->end()
                ->end()
                ->arrayNode('logger')
                    ->children()
                        ->arrayNode('elasticsearch')
                            ->children()
                                ->booleanNode('enabled')->defaultFalse()->end()
                                ->scalarNode('username')->isRequired()->end()
                                ->scalarNode('password')->isRequired()->end()
                                ->scalarNode('url')->isRequired()->end()
                                ->scalarNode('index')->isRequired()->end()
                            ->end()
                        ->end()
                        ->scalarNode('project_dir')->isRequired()->end()
                        ->arrayNode('exclusions')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('channel')->isRequired()->end()
                                    ->scalarNode('message')->isRequired()->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('jwt_http_client')
                    ->children()
                        ->arrayNode('clients')
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('http_client')->isRequired()->end()
                                    ->scalarNode('jwt_storage')->isRequired()->end()
                                    ->arrayNode('auth')
                                        ->isRequired()
                                        ->children()
                                            ->scalarNode('username')->isRequired()->end()
                                            ->scalarNode('password')->isRequired()->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('symfony_behat_api')
                    ->children()
                        ->booleanNode('cli')->defaultFalse()->end()
                        ->booleanNode('doctrine')->defaultFalse()->end()
                        ->booleanNode('http_client')->defaultFalse()->end()
                        ->booleanNode('jwt')->defaultFalse()->end()
                        ->booleanNode('rest_api')->defaultFalse()->end()
                    ->end()
                ->end()
                ->arrayNode('swagger')
                    ->children()
                        ->scalarNode('output_dir')->defaultValue('.generated')->end()
                        ->booleanNode('enable_clients')->defaultFalse()->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
