<?php

declare(strict_types=1);

namespace Avodel\Healthcheck\Controller;

use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

final class HealthcheckController
{
    public function __invoke(LoggerInterface $logger): JsonResponse
    {
        $logger->debug('Healthcheck request received.');

        return new JsonResponse(['status' => 'ok']);
    }
}
