<?php

declare(strict_types=1);

namespace Avodel\Logger\Kibana;

use Monolog\Formatter\NormalizerFormatter;
use Monolog\LogRecord;
use function count;

final class KibanaFormatter extends NormalizerFormatter
{
    public function format(LogRecord $record)
    {
        $recordData = parent::format($record);

        $message = [
            '@timestamp' => $recordData['datetime'],
            '@version' => 1,
            'host' => gethostname(),
        ];

        if (isset($recordData['message'])) {
            $message['message'] = $recordData['message'];
        }

        if (isset($recordData['channel'])) {
            $message['channel'] = $recordData['channel'];
        }

        if (isset($recordData['level_name'])) {
            $message['level'] = $recordData['level_name'];
        }

        if (isset($recordData['level'])) {
            $message['monolog_level'] = $recordData['level'];
        }

        if (isset($recordData['context']['exception_file_lines'])) {
            $recordData['extra']['exception_file_lines'] = $recordData['context']['exception_file_lines'];
            unset($recordData['context']['exception_file_lines']);
        }

        if (isset($recordData['context']['exception_messages'])) {
            $recordData['extra']['exception_messages'] = $recordData['context']['exception_messages'];
            unset($recordData['context']['exception_messages']);
        }

        if (count($recordData['extra']) > 0) {
            foreach ($recordData['extra'] as $key => $value) {
                $message[$key] = $value;
            }
        }

        if (count($recordData['context']) > 0) {
            $message['context'] = ContextDataDumper::dump($recordData['context']);
        }

        return $this->toJson($message) . "\n";
    }
}
