<?php

namespace Avodel\Logger\DependencyInjection;

use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\Config\FileLocator;

final class AvodelLoggerExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/Config/'));
        $loader->load('services.yaml');

        /** @var ConfigurationInterface $configuration */
        $configuration = $this->getConfiguration([], $container);

        /** @var array<string,string> $config */
        $config = $this->processConfiguration($configuration, $configs);

        $container->setParameter('avodel.logger.elasticsearch.url', $config['elasticsearch']['url']);
        $container->setParameter('avodel.logger.elasticsearch.username', $config['elasticsearch']['username']);
        $container->setParameter('avodel.logger.elasticsearch.password', $config['elasticsearch']['password']);
        $container->setParameter('avodel.logger.elasticsearch.index', $config['elasticsearch']['index']);
        $container->setParameter('avodel.logger.elasticsearch.enabled', $config['elasticsearch']['enabled']);
        $container->setParameter('avodel.logger.project_dir', $config['project_dir']);
        $container->setParameter('avodel.logger.exclusions', $config['exclusions']);
    }
}
