<?php

namespace Avodel\Logger\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_logger');
        $treeBuilder->getRootNode()->children()
            ->arrayNode('elasticsearch')
                ->children()
                    ->booleanNode('enabled')->defaultFalse()->end()
                    ->scalarNode('username')->isRequired()->end()
                    ->scalarNode('password')->isRequired()->end()
                    ->scalarNode('url')->isRequired()->end()
                    ->scalarNode('index')->isRequired()->end()
                ->end()
            ->end()
            ->scalarNode('project_dir')->isRequired()->end()
            ->arrayNode('exclusions')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('channel')->isRequired()->end()
                        ->scalarNode('message')->isRequired()->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
