<?php

namespace Avodel\Logger\Handler;

use Monolog\Handler\Handler;
use Monolog\Handler\NullHandler;
use Symfony\Bridge\Monolog\Handler\ElasticsearchLogstashHandler;

final class ElasticSearchHandlerFactory
{
    public function __construct(private readonly ElasticsearchLogstashHandler $elasticsearchLogstashHandler)
    {
    }

    public function create(bool $isElasticEnabled): Handler
    {
        if ($isElasticEnabled) {
            return $this->elasticsearchLogstashHandler;
        }

        return new NullHandler();
    }
}