<?php

declare(strict_types=1);

namespace Avodel\Logger\Handler;

use Monolog\Handler\AbstractHandler;
use Monolog\LogRecord;

final class ExclusionsHandler extends AbstractHandler
{
    private array $exclusionsMap = [];

    public function __construct(private readonly array $exclusions)
    {
        parent::__construct();

        foreach ($this->exclusions as $exclusion) {
            $this->exclusionsMap[$exclusion['channel']][$exclusion['message']] = true;
        }
    }

    public function handle(LogRecord $record): bool
    {
        return isset($this->exclusionsMap[$record->channel][$record->message]);
    }
}
