<?php

namespace Avodel\Messenger\Bezkolejki;

use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;

final class MadeAppointmentMessage
{
    public function __construct(
        private readonly int $appointmentRequestId,
        private readonly int $userId,
        #[Context([DateTimeNormalizer::FORMAT_KEY => 'Y-m-d\TH:i:s\Z'])]
        private readonly \DateTimeImmutable $appointmentDate,
        private readonly int $appointmentCode,
    ) {
    }

    public function getAppointmentRequestId(): int
    {
        return $this->appointmentRequestId;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getAppointmentDate(): \DateTimeImmutable
    {
        return $this->appointmentDate;
    }

    public function getAppointmentCode(): int
    {
        return $this->appointmentCode;
    }
}
