<?php

namespace Avodel\Messenger\MailService;

final class IncomingEmailMessage
{
    public function __construct(
        private readonly int $id,
        private readonly string $subject,
        private readonly string $from,
        private readonly string $to,
        private readonly string $body,
    )
    {
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getSubject(): string
    {
        return $this->subject;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function getBody(): string
    {
        return $this->body;
    }
}
