<?php

namespace Avodel\Messenger\MazowieckiePobytCzasowy;

use Symfony\Component\Serializer\Annotation\Context;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;

final class MadeAppointmentMessage
{
    public function __construct(
        private readonly int $applicationRequestId,
        private readonly int $userId,
        private readonly string $location,
        #[Context([DateTimeNormalizer::FORMAT_KEY => 'Y-m-d\TH:i:s\Z'])]
        private readonly \DateTimeImmutable $date,
        private readonly string $reservationNumber,
    )
    {
    }

    public function getApplicationRequestId(): int
    {
        return $this->applicationRequestId;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getLocation(): string
    {
        return $this->location;
    }

    public function getDate(): \DateTimeImmutable
    {
        return $this->date;
    }

    public function getReservationNumber(): string
    {
        return $this->reservationNumber;
    }
}
