# Avodel Messenger

A shared message models library for microservices communication via message broker.

## Overview

This package provides a centralized collection of message models (events, commands) that are shared between microservices in the Avodel ecosystem. These models are used for asynchronous communication through message brokers (RabbitMQ, Kafka, etc.).

## Message Categories

### UserProfile
- `UserCreated` - Dispatched when a new user is created
- `LanguageChanged` - Dispatched when user changes their language preference

### Payments
- `InvoicePaid` - Dispatched when an invoice is successfully paid

### MailService
- `IncomingEmailMessage` - Incoming email message data

### SmsService
- `IncomingSmsMessage` - Incoming SMS message data
