<?php

declare(strict_types=1);

namespace Avodel\Messenger\Payments;

final class InvoicePaid
{
    public function __construct(
        private readonly int $invoiceId,
        private readonly int $userId,
    )
    {
    }

    public function getInvoiceId(): int
    {
        return $this->invoiceId;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }
}
