<?php

namespace Avodel\Messenger\SmsService;

final class IncomingSmsMessage
{
    public function __construct(
        private readonly string $from,
        private readonly string $to,
        private readonly string $body,
    )
    {
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function getBody(): string
    {
        return $this->body;
    }
}
