<?php

declare(strict_types=1);

namespace Avodel\Messenger\UserProfile;

final class UserCreated
{
    public function __construct(
        private readonly int $userId,
        private readonly ?int $telegramUserId,
    ) {
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getTelegramUserId(): ?int
    {
        return $this->telegramUserId;
    }
}
