<?php

declare(strict_types=1);

namespace Avodel\MigrationLock;

use Symfony\Component\Console\ConsoleEvents;
use Symfony\Component\Console\Event\ConsoleCommandEvent;
use Symfony\Component\Console\Event\ConsoleTerminateEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Lock\LockFactory;
use Symfony\Component\Lock\LockInterface;

class LockDoctrineMigrationListener implements EventSubscriberInterface
{
    private const string MIGRATION_COMMAND_NAME = 'doctrine:migrations:migrate';
    private const int LOCK_TTL = 300;

    private ?LockInterface $lock = null;

    public function __construct(
        private readonly LockFactory $lockFactory,
        private readonly string $prefix,
    ) {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            ConsoleEvents::COMMAND => 'onCommand',
            ConsoleEvents::TERMINATE => 'onTerminate',
        ];
    }

    public function onCommand(ConsoleCommandEvent $event): void
    {
        $commandName = $event->getCommand()->getName();

        if (self::MIGRATION_COMMAND_NAME === $commandName) {
            $lockKey = $this->prefix . ':' . $commandName;
            $this->lock = $this->lockFactory->createLock($lockKey, self::LOCK_TTL);
            $this->lock->acquire(true);
        }
    }

    public function onTerminate(ConsoleTerminateEvent $event): void
    {
        $commandName = $event->getCommand()->getName();

        if (self::MIGRATION_COMMAND_NAME === $commandName && $this->lock !== null) {
            $this->lock->release();
            $this->lock = null;
        }
    }
}
