# Avodel Skeleton Setup

A Symfony Flex recipe package that provides base project configuration for Avodel services.

## Overview

This package contains Symfony Flex recipes that are automatically applied when the `avodel/skeleton-setup` dependency is installed. The key benefit is that **recipe updates are automatically pulled** by any project that depends on this package, ensuring consistent configuration across all services.

## How It Works

Symfony Flex uses recipe manifests (like `avodel.skeleton-setup.1.0.json`) to configure projects automatically. When you install this package:

1. Files are copied to your project
2. Docker Compose services are configured
3. `.gitignore` entries are added
4. Configuration files are created

## Installation

```bash
composer require avodel/skeleton-setup
```

Symfony Flex will automatically apply the recipe configuration.

## Recipe Manifest Structure

```json
{
  "manifests": {
    "avodel/skeleton-setup": {
      "manifest": {
        "copy-from-recipe": { ... },
        "gitignore": [ ... ],
        "docker-compose": { ... }
      },
      "files": { ... },
      "ref": "commit-hash"
    }
  }
}
```

## Updating Recipes

When this package is updated, dependent projects receive the new configuration automatically on the next `composer update` or when Symfony Flex synchronizes recipes.
