<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

class Property
{
    public function __construct(
        private readonly ?string $type,
        private readonly ?string $format,
        private readonly ?string $description,
        private readonly ?PropertyItems $items,
        private readonly ?string $ref,
    )
    {
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getFormat(): ?string
    {
        return $this->format;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getItems(): ?PropertyItems
    {
        return $this->items;
    }

    public function getRef(): ?string
    {
        return $this->ref;
    }
}