<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

final class SchemasCollection
{
    /**
     * @var array<string, Schema>
     */
    private array $schemas = [];

    public function addSchema(string $ref, Schema $schema): void
    {
        $this->schemas[$ref] = $schema;
    }

    public function getSchema(string $ref): Schema
    {
        return $this->schemas[$ref];
    }

    /**
     * @return array<string, Schema>
     */
    public function getAll(): array
    {
        return $this->schemas;
    }
}