<?php

namespace Avodel\SwaggerCodeGenerator\Generator\Util;

final class PropertyTypeResolver
{
    public function resolve(string $openApiPropertyType, ?string $format): string
    {
        if ($openApiPropertyType === 'string' && ($format === 'date-time' || $format === 'date')) {
            return '\DateTimeImmutable';
        }

        return match ($openApiPropertyType) {
            'string' => 'string',
            'integer' => 'int',
            'number' => 'float',
            'boolean' => 'bool',
            'array' => 'array',
            'object' => 'object',
            default => throw new \RuntimeException('Unknown type: ' . $openApiPropertyType)
        };
    }
}