<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

final class PropertyCollection
{
    /**
     * @var array<string, Property>
     */
    private array $properties;

    public function addProperty(string $name, Property $property): void
    {
        $this->properties[$name] = $property;
    }

    public function getProperty(string $name): Property
    {
        return $this->properties[$name];
    }

    /**
     * @return array<string, Property>
     */
    public function getAll(): array
    {
        return $this->properties;
    }

}