# Swagger Code Generator
This package generates models, api client and server from swagger specification.

## Installation in symfony
Install the package via composer:

```shell
composer require avodel/swagger-code-generator
```

Configuration in composer.json:
```yaml
 "scripts": {
  "auto-scripts": {
    "./vendor/avodel/swagger-code-generator/bin/swagger-gen --spec=./vendor/avodel/mazowieckie-pobyt-czasowy-api/swagger-api-config/stub-internal-api.yaml --feature=Stub --with-client --output-dir=./.generated": "php-script",
    "./vendor/avodel/swagger-code-generator/bin/swagger-gen --spec=./vendor/avodel/mazowieckie-pobyt-czasowy-api/swagger-api-config/task-api.yaml --feature=Task --with-client -output-dir=./.generated": "php-script",
    "cache:clear": "symfony-cmd",
    "assets:install %PUBLIC_DIR%": "symfony-cmd"
  },
  "post-install-cmd": [
    "@auto-scripts"
  ],
  "post-update-cmd": [
    "@auto-scripts"
  ]
},
```

## Example
```yaml
swagger: '2.0'
info:
  title: Test
  description: Test
  version: 1.0.0
paths:
  /pets/{petId}:
    get:
      summary: Find pet by ID
      description: Returns a single pet
      operationId: getPetById
      parameters:
        - name: petId
          in: path
          required: true
          type: integer
          format: int64
      responses:
        200:
          description: successful operation
          schema:
            $ref: '#/definitions/Product'
        400:
          description: Invalid ID supplied
        404:
          description: Pet not found
  /pets:
    get:
      summary: Find all pets
      description: Returns a single pet
      operationId: getAllPets
      responses:
        200:
          description: successful operation
          schema:
            type: array
            items:
              $ref: '#/definitions/Product'
  /books:
    post:
      summary: Add a new book
      operationId: addBook
      parameters:
        - name: book
          in: body
          description: Book object that needs to be added to the store
          required: true
          schema:
            $ref: '#/definitions/BookInput'
        - name: petId
          in: query
          required: false
          type: string
      responses:
        201:
          description: Book created successfully
        400:
          description: Invalid input
definitions:
  Product:
    type: object
    properties:
      parts:
        type: array
        items:
          $ref: '#/definitions/Part'
  Part:
    type: object
    required:
      - id
      - name
    properties:
      id:
        type: integer
        format: int64
      name:
        type: string
  BookInput:
    type: object
    required:
      - title
      - author
    properties:
      title:
        type: string
      author:
        type: string
      genre:
        type: string
      year:
        type: integer
```

```shell
php bin/console avodel:swagger-code-generator:generate --spec=src/swagger.yaml --feature=Product --with-server --with-client
```