<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

final class ParametersCollection
{
    /**
     * @var array<string, Parameter>
     */
    private array $parameters = [];

    public function addParameter(string $name, Parameter $parameter): void
    {
        $this->parameters[$name] = $parameter;
    }

    /**
     * @return array<string, Parameter>
     */
    public function getAll(): array
    {
        return $this->parameters;
    }
}