<?= "<?php\n" ?>

namespace <?= $controller->namespace; ?>;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\HttpKernel\Exception\HttpException;
use OpenApi\Attributes as OA;
use Nelmio\ApiDocBundle\Annotation\Model;
<?php foreach ($controller->uses as $use): ?>
use <?= $use ?>;
<?php endforeach; ?>

abstract class <?= $controller->name ?> extends AbstractController
{
<?php foreach ($controller->endpoints as $endpoint): ?><?="\n"?>
<?= $endpoint->swaggerAnnotations ?>
    #[Route('<?= $endpoint->path ?>', methods: ['<?= strtoupper($endpoint->requestMethod) ?>'], format: 'json')]
<?php if($endpoint->phpDocs): ?>
    /**
<?php foreach ($endpoint->phpDocs as $phpDoc): ?>
     * <?= $phpDoc ?><?="\n"?>
<?php endforeach; ?>
     */
<?php endif; ?>
    public function <?= $endpoint->name ?>(Request $request, <?php foreach ($endpoint->parameters as $param): ?><?= $param->useMapRequestPayload ? '#[MapRequestPayload] ' : '' ?><?= $param->nullable ? '?' : '' ?><?= $param->type ?> <?= '$' . $param->camelCaseName ?>, <?php endforeach; ?>): Response
    {
<?php foreach ($endpoint->queryParameters as $queryParameter): ?>
<?php if($queryParameter->type === '\DateTimeImmutable'): ?>
<?php if($queryParameter->nullable): ?>
        $<?= $queryParameter->camelCaseName ?> = $request->query->get('<?= $queryParameter->name ?>') !== null ? new \DateTimeImmutable($request->query->get('<?= $queryParameter->name ?>')) : null;<?="\n"?>
<?php else: ?>
        $<?= $queryParameter->camelCaseName ?> = new \DateTimeImmutable($request->query->get('<?= $queryParameter->camelCaseName ?>'));<?="\n"?>
<?php endif; ?>
<?php else: ?>
        $<?= $queryParameter->camelCaseName ?> = $request->query->get('<?= $queryParameter->name ?>');<?="\n"?>
<?php endif; ?>
<?php endforeach; ?>
        try {
            return $this->handle<?= ucfirst($endpoint->name) ?>($request, <?php foreach ($endpoint->parameters as $param): ?> <?= '$' . $param->camelCaseName ?>, <?php endforeach; ?><?php foreach ($endpoint->queryParameters as $queryParameter): ?><?= '$' . $queryParameter->camelCaseName ?>, <?php endforeach; ?>);
        } catch(HttpException $e) {
            return new Response(null, $e->getStatusCode());
        }
    }

    abstract protected function handle<?= ucfirst($endpoint->name) ?>(Request $request, <?php foreach ($endpoint->parameters as $param): ?><?= $param->nullable ? '?' : '' ?><?= $param->type ?> <?= '$' . $param->camelCaseName ?>, <?php endforeach; ?><?php foreach ($endpoint->queryParameters as $queryParameters): ?><?= $queryParameters->nullable ? '?' : '' ?><?= $queryParameters->type ?> <?= '$' . $queryParameters->camelCaseName ?>, <?php endforeach; ?>): Response;
<?php endforeach; ?>
}
