<?php

namespace Avodel\SwaggerCodeGenerator\Generator;

use Avodel\SwaggerCodeGenerator\Generator\Model\ClassModel;
use Avodel\SwaggerCodeGenerator\Generator\Model\ClassProperty;
use Avodel\SwaggerCodeGenerator\Generator\Model\EnumClass;
use Avodel\SwaggerCodeGenerator\Generator\Util\FileManager;
use Avodel\SwaggerCodeGenerator\Generator\Util\PropertyTypeResolver;
use Avodel\SwaggerCodeGenerator\Parser\Schema\Property;
use Avodel\SwaggerCodeGenerator\Parser\Schema\Schema;
use Avodel\SwaggerCodeGenerator\Parser\Schema\Specification;

final class EnumGenerator
{
    public function __construct(
        private readonly FileManager $fileManager,
    )
    {
    }

    public function generate(Specification $specification, string $outputDir, string $namespaceValue): void
    {
        foreach ($specification->getSchemasCollection()->getAll() as $ref => $schema) {
            if (!$schema->getEnum()) {
                continue;
            }

            $enumClass = new EnumClass();
            $enumClass->namespace = $namespaceValue;

            $modelName = $schema::getModelNameFromRef($ref);
            $enumClass->name = $modelName;
            $enumClass->namespace = $namespaceValue;
            $enumClass->values = $schema->getEnum();

            $code = $this->fileManager->parseTemplate('enum.tpl.php', ['enum' => $enumClass]);
            $this->fileManager->dumpFile("$outputDir/$modelName.php", $code);
        }
    }
}