<?php

namespace Avodel\SwaggerCodeGenerator\Generator;

use Avodel\SwaggerCodeGenerator\Generator\Model\ExceptionModel;
use Avodel\SwaggerCodeGenerator\Generator\Util\FileManager;

class ExceptionGenerator
{
    public function __construct(
        private readonly FileManager $fileManager,
    )
    {
    }

    public function generateClient(string $text, string $outputDir, string $namespaceValue): string
    {
        $exceptionModel = new ExceptionModel();
        $exceptionModel->name = $this->generateExceptionClassName($text);
        $exceptionModel->namespace = $namespaceValue;

        $code = $this->fileManager->parseTemplate('exception_client.tpl.php', ['exception' => $exceptionModel]);
        $this->fileManager->dumpFile("$outputDir/{$exceptionModel->name}.php", $code);

        return $exceptionModel->namespace . '\\' . $exceptionModel->name;
    }

    public function generateServer(string $text, int $statusCode, string $outputDir, string $namespaceValue): string
    {
        $exceptionModel = new ExceptionModel();
        $exceptionModel->name = $this->generateExceptionClassName($text);
        $exceptionModel->namespace = $namespaceValue;
        $exceptionModel->httpStatusCode = $statusCode;

        $code = $this->fileManager->parseTemplate('exception_server.tpl.php', ['exception' => $exceptionModel]);
        $this->fileManager->dumpFile("$outputDir/{$exceptionModel->name}.php", $code);

        return $exceptionModel->namespace . '\\' . $exceptionModel->name;
    }

    private function generateExceptionClassName(string $errorDescription): string
    {
        $words = preg_split('/\s+/', $errorDescription);
        $className = '';

        foreach ($words as $word) {
            $className .= ucfirst(strtolower($word));
        }

        $className .= 'Exception';

        return $className;
    }
}