<?php

namespace Avodel\SwaggerCodeGenerator\Generator\Util;

use Symfony\Component\Filesystem\Filesystem;

final class FileManager
{
    public function __construct()
    {
    }

    public function parseTemplate(string $templatePath, array $parameters): string
    {
        ob_start();
        extract($parameters, \EXTR_SKIP);
        include __DIR__ . '/../../Resources/skeleton/' . $templatePath;

        return ob_get_clean();
    }

    public function dumpFile(string $filename, string $content): void
    {
        $directory = dirname($filename);

        if (!file_exists($directory) && !mkdir($directory, 0777, true) && !is_dir($directory)) {
            throw new \RuntimeException(sprintf('Directory "%s" was not created', $directory));
        }

        file_put_contents($filename, $content);
    }

    public function removeDir(string $path): void
    {
        $filesystem = new Filesystem();
        $filesystem->remove($path);
    }
}
