<?php

namespace Avodel\SwaggerCodeGenerator\Generator;

use Symfony\Component\Yaml\Yaml;

final class ClientServiceDefinitionsRegistrar
{
    public function registry(string $outputDir, string $clientName, string $class, string $interface): void
    {
        $existingData = [];

        if (file_exists($outputDir . '/rest_api_clients.yaml')) {
            $yamlContents = file_get_contents($outputDir . '/rest_api_clients.yaml');
            $existingData = Yaml::parse($yamlContents);
        }

        $httpClientName = 'avodel.swagger_code_generator.' . strtolower($clientName) . '.http_client';
        $existingData['services'][$httpClientName] = '@http_client';

        $existingData['services'][$interface] = [
            'class' => $class,
            'public' => false,
            'arguments' => [
                '$httpClient' => '@' . $httpClientName,
                '$serializer' => '@serializer',
            ],
        ];

        file_put_contents($outputDir . '/rest_api_clients.yaml', Yaml::dump($existingData));
    }
}