<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

final class Schema
{
    public function __construct(
        private readonly ?string $type,
        private readonly PropertyCollection $propertiesCollection,
        private readonly array $requiredProperties,
        private readonly ?string $ref,
        private readonly ?Schema $items,
        /**
         * @var string[]
         */
        private readonly array $enum,
        private readonly ?string $format,
    )
    {
    }
    public static function getModelNameFromRef(string $ref): string
    {
        $parts = explode('/', $ref);

        return $parts[count($parts) - 1];
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @return string[]
     */
    public function getRequiredProperties(): array
    {
        return $this->requiredProperties;
    }

    public function getPropertiesCollection(): PropertyCollection
    {
        return $this->propertiesCollection;
    }

    public function getRef(): ?string
    {
        return $this->ref;
    }

    public function getSchemaItems(): ?Schema
    {
        return $this->items;
    }

    /**
     * @return string[]
     */
    public function getEnum(): array
    {
        return $this->enum;
    }

    public function getFormat(): ?string
    {
        return $this->format;
    }
}
