<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

class Operation
{
    public function __construct(
        private readonly ?string $summary,
        private readonly ?string $description,
        private readonly string $operationId,
        private readonly ParametersCollection $parametersCollection,
        private readonly ResponsesCollection $responsesCollection,
        private readonly array $tags,
    )
    {
    }

    public function getSummary(): ?string
    {
        return $this->summary;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getOperationId(): string
    {
        return $this->operationId;
    }

    public function getParametersCollection(): ParametersCollection
    {
        return $this->parametersCollection;
    }

    public function getResponsesCollection(): ResponsesCollection
    {
        return $this->responsesCollection;
    }

    public function getTags(): array
    {
        return $this->tags;
    }
}
