<?= "<?php\n" ?>

namespace <?= $class->namespace; ?>;

<?php foreach ($class->uses as $use): ?>
use <?= $use ?>;
<?php endforeach; ?>

final class <?= $class->name."\n" ?>
{
    public function __construct(
<?php foreach ($class->properties as $property): ?>
<?php if($property->type === 'array' && $property->arrayPhpdoc): ?>
        /**
         * @var <?= $property->arrayPhpdoc ?><?= $property->nullable ? '|null' : '' ?><?="\n"?>
         */
<?php endif; ?>
<?php foreach ($property->attributes as $attribute): ?>
        <?= $attribute ?><?="\n"?>
<?php endforeach; ?>
        private <?= !$property->resetTime ? 'readonly ' : '' ?><?= $property->nullable ? '?' : '' ?><?= $property->type ?> $<?= $property->name ?>,
<?php endforeach; ?>
    )
    {
<?php foreach ($class->properties as $property): ?>
<?php if($property->resetTime === true && $property->type === '\DateTimeImmutable'): ?>
        $this-><?= $property->name ?> = $<?= $property->name ?>?->setTime(0, 0, 0);
<?php endif; ?>
<?php if($property->resetTime === true && $property->type === 'array'): ?>
<?php $createResetTimesMethod = true; ?>
        $this-><?= $property->name ?> = $this->resetTimes($<?= $property->name ?>);
<?php endif; ?>
<?php endforeach; ?>
    }

<?php if(isset($createResetTimesMethod) && $createResetTimesMethod === true): ?>
    /**
     * @param array<\DateTimeImmutable> $data
     * @return array<\DateTimeImmutable>|null
     */
    private function resetTimes(?array $data): ?array
    {
        if ($data === null) {
            return null;
        }
        foreach ($data as &$value) {
            if (is_array($value)) {
                $value = $this->resetTimes($value);
            } elseif ($value instanceof \DateTimeImmutable) {
                $value = $value->setTime(0, 0, 0);
            }
        }

        return $data;
    }
<?php endif; ?>

<?php foreach ($class->properties as $property): ?>
<?php if($property->type === 'array' && $property->arrayPhpdoc): ?>
    /**
     * @return <?= $property->arrayPhpdoc ?><?= $property->nullable ? '|null' : '' ?><?="\n"?>
     */
<?php endif; ?>
    public function get<?= ucfirst($property->name) ?>(): <?= $property->nullable ? '?' : '' ?><?= $property->type ?><?="\n"?>
    {
        return $this-><?= $property->name ?>;
    }

<?php endforeach; ?>

    public static function builder(): <?= $class->builderName."\n" ?>
    {
        return new <?= $class->builderName ?>();
    }
}
