<?php

namespace Avodel\SwaggerCodeGenerator\Generator;

use Avodel\SwaggerCodeGenerator\Generator\Options\GeneratorOptions;
use Avodel\SwaggerCodeGenerator\Generator\Util\FileManager;
use Avodel\SwaggerCodeGenerator\Parser\Parser;

class Generator
{
    public function __construct(
        private readonly Parser $parser,
        private readonly ModelGenerator $modelGenerator,
        private readonly EnumGenerator $enumGenerator,
        private readonly ClientGenerator $clientGenerator,
        private readonly ControllerGenerator $controllerGenerator,
        private readonly FileManager $fileManager,
        private readonly string $outputRootDir,
    )
    {
    }

    public function generate(GeneratorOptions $generatorOptions): void
    {
        $featureDir = $this->outputRootDir . DIRECTORY_SEPARATOR . $generatorOptions->getFeature() . '/';
        $this->fileManager->removeDir($featureDir);

        $specification = $this->parser->parse($generatorOptions->getSpecPath());
        $namespace = 'Generated\\' . $generatorOptions->getFeature();
        $modelNamespace = $namespace . '\\Model';

        $this->modelGenerator->generate(
            $specification,
            $featureDir . 'Model',
            $modelNamespace
        );

        $this->enumGenerator->generate(
            $specification,
            $featureDir . 'Model',
            $modelNamespace
        );

        if ($generatorOptions->isWithClient()) {
            $this->clientGenerator->generate(
                $specification,
                $featureDir . '/Client',
                $namespace . '\\Client',
                $generatorOptions->getFeature(),
                $modelNamespace,
                $featureDir . '/Client/Exception',
                $namespace . '\\Client\\Exception',
                $this->outputRootDir
            );


        }

        if ($generatorOptions->isWithServer()) {
            $this->controllerGenerator->generate(
                $specification,
                $featureDir . '/Server',
                $namespace . '\\Server',
                $generatorOptions->getFeature(),
                $modelNamespace,
                $featureDir . '/Server/Exception',
                $namespace . '\\Server\\Exception'
            );
        }
    }
}
