<?php

namespace Avodel\SwaggerCodeGenerator\Generator\Options;

final class GeneratorOptions
{
    public function __construct(
        private readonly string $specPath,
        private readonly string $feature,
        private readonly bool $withServer,
        private readonly bool $withClient,
    )
    {
    }

    public static function builder(): GeneratorOptionsBuilder
    {
        return new GeneratorOptionsBuilder();
    }

    public function getSpecPath(): string
    {
        return $this->specPath;
    }

    public function getFeature(): string
    {
        return $this->feature;
    }

    public function isWithServer(): bool
    {
        return $this->withServer;
    }

    public function isWithClient(): bool
    {
        return $this->withClient;
    }
}