<?php

namespace Avodel\SwaggerCodeGenerator\Generator\Options;

/**
 * @internal
 */
class GeneratorOptionsBuilder
{
    private ?string $specPath = null;
    private ?string $feature = null;
    private bool $withServer = false;
    private bool $withClient = false;

    public function specPath(string $specPath): self
    {
        $this->specPath = $specPath;

        return $this;
    }

    public function feature(string $feature): self
    {
        $this->feature = $feature;

        return $this;
    }

    public function withServer(): self
    {
        $this->withServer = true;

        return $this;
    }

    public function withClient(): self
    {
        $this->withClient = true;

        return $this;
    }

    public function build(): GeneratorOptions
    {
        return new GeneratorOptions(
            $this->specPath,
            $this->feature,
            $this->withServer,
            $this->withClient
        );
    }
}