<?php

namespace Avodel\SwaggerCodeGenerator\Generator;

use Avodel\SwaggerCodeGenerator\Parser\Schema\Operation;
use Avodel\SwaggerCodeGenerator\Parser\Schema\Schema;

class SwaggerAnnotationsGenerator
{
    public function generate(Operation $operation): string
    {
        $annotations = '';

        foreach ($operation->getResponsesCollection()->getAll() as $code => $response) {
            $annotations .= $this->ident(1) . '#[OA\Response(' . PHP_EOL;
            $annotations .= $this->ident(2) . 'response: ' . $code . ', ' . PHP_EOL;
            $annotations .= $this->ident(2) . 'description: "' . $response->getDescription() . '", ' . PHP_EOL;

            if ($response->getSchema() && $response->getSchema()->getRef()) {
                $className = Schema::getModelNameFromRef($response->getSchema()->getRef());
                $annotations .= $this->ident(2) . 'content: new OA\JsonContent(ref: new Model(type: ' . $className . '::class)), ' . PHP_EOL;
            }

            if ($response->getSchema() && $response->getSchema()->getType() === 'array') {
                $annotations .= $this->ident(2) . 'content: new OA\JsonContent(type: "array", items: new OA\Items(ref: new Model(type: ' . Schema::getModelNameFromRef($response->getSchema()->getSchemaItems()->getRef()) . '::class))), ' . PHP_EOL;
            }

            $annotations .= $this->ident(1) . ')]' . PHP_EOL;
        }

        foreach ($operation->getParametersCollection()->getAll() as $name => $parameter) {
            if ($parameter->getIn() === 'body') {
                $annotations .= $this->ident(1) . '#[OA\RequestBody(' . PHP_EOL;
                $annotations .= $this->ident(2) . 'description: "' . $parameter->getDescription() . '", ' . PHP_EOL;
                $annotations .= $this->ident(2) . 'required: ' . ($parameter->isRequired() ? 'true' : 'false') . ', ' . PHP_EOL;

                $className = Schema::getModelNameFromRef($parameter->getSchema()->getRef());
                $annotations .= $this->ident(2) . 'content: new OA\JsonContent(ref: new Model(type: ' . $className . '::class)), ' . PHP_EOL;
                $annotations .= $this->ident(1) . ')]' . PHP_EOL;
                continue;
            }

            $annotations .= $this->ident(1) . '#[OA\Parameter(' . PHP_EOL;
            $annotations .= $this->ident(2) . 'name: "' . $name . '", ' . PHP_EOL;
            $annotations .= $this->ident(2) . 'description: "' . $parameter->getDescription() . '", ' . PHP_EOL;
            $annotations .= $this->ident(2) . 'in: "' . $parameter->getIn() . '", ' . PHP_EOL;

            $annotations .= $this->ident(1) . ')]' . PHP_EOL;
        }

        foreach ($operation->getTags() as $tag) {
            $annotations .= $this->ident(1) . '#[OA\Tag(name: "' . $tag . '")]' . PHP_EOL;
        }

        return $annotations;
    }

    private function ident(int $times): string
    {
        return str_repeat('    ', $times);
    }

}
