<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

class Parameter
{
    public function __construct(
        private readonly string $in,
        private readonly bool $required,
        private readonly ?string $description,
        private readonly ?string $type,
        private readonly ?string $format,
        private readonly ?Schema $schema,
    )
    {
    }

    public function getIn(): string
    {
        return $this->in;
    }

    public function isRequired(): bool
    {
        return $this->required;
    }

    public function getSchema(): ?Schema
    {
        return $this->schema;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getFormat(): ?string
    {
        return $this->format;
    }
}