<?php

namespace Avodel\SwaggerCodeGenerator\Parser\Schema;

class Property
{
    public function __construct(
        private readonly ?string $type,
        private readonly ?string $format,
        private readonly ?string $description,
        private readonly ?Schema $items,
        private readonly ?string $ref,
        private readonly ?string $pattern,
    )
    {
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getFormat(): ?string
    {
        return $this->format;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getItems(): ?Schema
    {
        return $this->items;
    }

    public function getRef(): ?string
    {
        return $this->ref;
    }

    public function getPattern(): ?string
    {
        return $this->pattern;
    }
}
