<?= "<?php\n" ?>

namespace <?= $clientApi->namespace; ?>;

use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;
<?php foreach ($clientApi->uses as $use): ?>
use <?= $use ?>;
<?php endforeach; ?>

final class <?= $clientApi->name ?> implements <?= $clientApi->interfaceName."\n" ?>
{
    public function __construct(
        private readonly HttpClientInterface $httpClient,
        private readonly SerializerInterface $serializer,
    )
    {
    }

<?php foreach ($clientApi->operations as $operation): ?>
<?php if($operation->throwsExceptions || $operation->returnTypehints): ?>
    /**
     * @inheritDoc
     */
<?php endif; ?>
    public function <?= $operation->name ?>(<?php foreach ($operation->params as $param): ?><?= $param->nullable ? '?' : '' ?><?= $param->type ?> <?= '$' . $param->camelCaseName ?>, <?php endforeach; ?>): <?= !$operation->returnTypes ? 'void' : implode('|', $operation->returnTypes) ?><?="\n"?>
    {
        $response = $this->httpClient->request('<?=$operation->requestMethod?>', "<?=$operation->uri?>", [
<?php if($operation->queryParams): ?>
            'query' => [
<?php foreach ($operation->queryParams as $param): ?>
<?php $nullable = $param->nullable ? '?' : ''?>
                <?="'" . $param->name . "'"?> => $<?=$param->format === 'date' ? $param->camelCaseName.$nullable.'->format("Y-m-d")' : ($param->format === 'date-time' ? $param->camelCaseName.$nullable.'->format("Y-m-d\TH:i:s\Z")': $param->camelCaseName)?>,<?="\n"?>
<?php endforeach; ?>
            ],
<?php endif; ?>
<?php if($operation->bodyParam): ?>
            'body' => $this->serializer->serialize($<?=$operation->bodyParam->camelCaseName?>, 'json'),
            'headers' => ['Content-Type: application/json'],
<?php endif; ?>
        ]);

<?php foreach ($operation->statusCodes as $statusCode): ?>
        if ($response->getStatusCode() === <?=$statusCode->code?>) {
<?php if($statusCode->exception): ?>
            throw new <?= $statusCode->exception ?>();
<?php elseif($statusCode->dataClass): ?>
            return $this->serializer->deserialize($response->getContent(), <?= $statusCode->dataClass ?>::class<?= $statusCode->isArray ? ". '[]'" : '' ?>, 'json');
<?php else: ?>
            return<?= $operation->returnTypes ? ' $response->getContent()' : '' ?>;
<?php endif ?>
        }
<?php endforeach; ?>

        throw new \RuntimeException('Unexpected API response code: ' . $response->getStatusCode());
    }

<?php endforeach; ?>
}
