<?= "<?php\n" ?>

namespace <?= $class->namespace; ?>;

<?php foreach ($class->uses as $use): ?>
use <?= $use ?>;
<?php endforeach; ?>

final class <?= $class->builderName."\n" ?>
{
<?php foreach ($class->properties as $property): ?>
<?php if($property->type === 'array' && $property->arrayPhpdoc): ?>
    /**
     * @var <?= $property->arrayPhpdoc ?><?= $property->nullable ? '|null' : '' ?><?="\n"?>
     */
<?php endif; ?>
    private ?<?= $property->type ?> $<?= $property->name ?> = null;
<?php endforeach; ?>

<?php foreach ($class->properties as $property): ?>
<?php if($property->type === 'array' && $property->arrayPhpdoc): ?>
    /**
     * @param <?= $property->arrayPhpdoc ?><?= $property->nullable ? '|null' : '' ?> $<?= $property->name ?><?="\n"?>
     */
<?php endif; ?>
    public function <?= $property->name ?>(<?= $property->nullable ? '?' : '' ?><?=$property->type?> $<?= $property->name ?>): self
    {
        $this-><?= $property->name ?> = $<?= $property->name ?>;

        return $this;
    }

<?php endforeach; ?>

    public function build(): <?= $class->name."\n"?>
    {
<?php foreach ($class->properties as $property): ?>
<?php if($property->nullable === false): ?>
        if ($this-><?= $property->name ?> === null) {
            throw new \InvalidArgumentException('The property "<?= $property->name ?>" cannot be null.');
        }
<?php endif; ?>
<?php endforeach; ?>

        return new <?= $class->name."(\n"?>
<?php foreach ($class->properties as $property): ?>
            $this-><?= $property->name ?>,
<?php endforeach; ?>
        );
    }
}
