# Swagger Specs

A centralized repository of OpenAPI/Swagger specifications for Avodel microservices architecture.

## Overview

This repository contains OpenAPI 3.0 specifications for all microservices in the Avodel ecosystem. These specifications serve as the single source of truth for API contracts, enabling consistent API design, documentation, and code generation across services.

## Repository Structure

The repository is organized by service, with each directory containing one or more OpenAPI specification files:

### Core Services
- **captcha-solver/** - CAPTCHA solving service
- **cursor-path/** - Cursor path tracking service
- **evaluation-service/** - Evaluation and assessment service
- **notification-service/** - Multi-channel notification service
- **organizations-service/** - Organization management service
- **proxy-manager/** - Proxy management and rotation service
- **selenium-manager/** - Selenium WebDriver management service
- **system-config/** - System configuration service
- **translation-service/** - Localization and translation service
- **web-bot-profiles/** - Web bot profile management

### Business Domain Services
- **inpol-appointment-management/** - Appointment booking and management (reservations, spots, tasks)
- **inpol-otc/** - Over-the-counter operations
- **mazovian-family-registration/** - Family registration system (applications, jobs, board site)

### Communication Services
- **mail-service/** - Email service (forwarding, messaging, webhooks)
- **sms-service/** - SMS messaging service
- **telegram/** - Telegram bot integration (bot management, chat actions)

### Payment & Billing
- **payments-service/** - Payment processing service
- **stripe/** - Stripe payment gateway integration (invoices, payment intents, payment links, products)
- **product-service/** - Product catalog and management

### User Management
- **user-profile-service/** - User profile and account management

## Usage

### Viewing Specifications

Each service directory contains YAML files that can be:
- Viewed in any OpenAPI-compatible viewer (Swagger UI, Redoc, etc.)
- Used for code generation
- Imported into API development tools (Postman, Insomnia, etc.)
