<?php

declare(strict_types=1);

namespace Avodel\SymfonyBehatApi\Cli;

use Behat\Behat\Context\Context;
use Symfony\Bundle\FrameworkBundle\Console\Application;
use Symfony\Component\Console\Input\ArgvInput;
use Symfony\Component\Console\Output\BufferedOutput;
use Symfony\Component\HttpKernel\KernelInterface;

class CliContext implements Context
{
    public function __construct(
        private readonly KernelInterface $kernel,
    ) {
    }

    /**
     * @Given /^I execute the "([^"]*)" command$/
     * @Given /^I execute the "([^"]*)" command with "([^"]*)" arguments$/
     */
    public function iExecuteTheCommand(string $commandName, string $argumentsData = ''): void
    {
        $arguments = ['behat-test', $commandName, '--env=test'];

        if ($argumentsData) {
            $argumentsData = str_replace("'", '"', $argumentsData);
            $arrayArguments = str_getcsv($argumentsData, ' ');
            array_push($arguments, ...$arrayArguments);
        }

        $application = new Application($this->kernel);
        $input = new ArgvInput($arguments);
        $application->doRun($input, new BufferedOutput());
    }
}
